//FloorMountingPosts.scad;

//Use FloorMountingPost four times 
//to generate four mounting posts;

//FloorMountingPost generates one mounting 
//post centered at the origin, resting on the 
//XY plane and standing vertically 
//above that plane;

include <UNO_Dimensions.scad>
use <UNO_FloorMountingPost.scad>;

module FloorMountingPosts()
{
      
echo("Begin FloorMountingPosts");
    
//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ -Fuzz;

//Four posts for UNO;
echo("BL = ", PostUnoBLx, PostUnoBLy);
translate([PostUnoBLx, PostUnoBLy, DeltaZ])
    FloorMountingPost();

echo("BR = ", PostUnoBRx, PostUnoBRy);
translate([PostUnoBRx, PostUnoBRy, DeltaZ])
    FloorMountingPost();

echo("TR = ", PostUnoTRx, PostUnoTRy);
translate([PostUnoTRx, PostUnoTRy, DeltaZ])
    FloorMountingPost();

echo("TL = ", PostUnoTLx, PostUnoTLy);
translate([PostUnoTLx, PostUnoTLy, DeltaZ])
    FloorMountingPost();

}
//
